<?php
// معالجة التصدير
if (isset($_GET['export'])) {
    $export_type = $_GET['export'];
    
    if ($export_type == 'cars') {
        $result = $conn->query("SELECT * FROM cars ORDER BY id");
        $filename = "cars_" . date('Y-m-d') . ".csv";
        $headers = ['الرقم', 'الماركة', 'الموديل', 'السنة', 'اللون', 'السعر/اليوم', 'الحالة', 'تاريخ الإضافة'];
    } elseif ($export_type == 'bookings') {
        $result = $conn->query("SELECT b.*, c.brand, c.model FROM bookings b LEFT JOIN cars c ON b.car_id = c.id ORDER BY b.id");
        $filename = "bookings_" . date('Y-m-d') . ".csv";
        $headers = ['رقم الحجز', 'اسم العميل', 'البريد', 'الهاتف', 'السيارة', 'تاريخ البداية', 'تاريخ النهاية', 'السعر الإجمالي', 'الحالة'];
    }
    
    if (isset($result) && $result->num_rows > 0) {
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        
        $output = fopen('php://output', 'w');
        
        // إضافة BOM لدعم العربية في Excel
        fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));
        
        // كتابة الرؤوس
        fputcsv($output, $headers);
        
        // كتابة البيانات
        while ($row = $result->fetch_assoc()) {
            if ($export_type == 'cars') {
                $data = [
                    $row['id'],
                    $row['brand'],
                    $row['model'],
                    $row['year'],
                    $row['color'],
                    $row['price_per_day'],
                    $row['status'],
                    $row['created_at']
                ];
            } else {
                $data = [
                    $row['id'],
                    $row['customer_name'],
                    $row['customer_email'],
                    $row['customer_phone'],
                    $row['brand'] . ' ' . $row['model'],
                    $row['start_date'],
                    $row['end_date'],
                    $row['total_price'],
                    $row['status']
                ];
            }
            fputcsv($output, $data);
        }
        
        fclose($output);
        exit();
    }
}
?>

<div class="stats-grid">
    <div class="stat-card">
        <div class="icon">🚗</div>
        <h3>تصدير بيانات السيارات</h3>
        <p style="margin: 15px 0; color: #7f8c8d;">تصدير قائمة السيارات بصيغة CSV</p>
        <a href="?page=export&export=cars" class="btn btn-primary">
            📥 تصدير السيارات
        </a>
    </div>
    
    <div class="stat-card">
        <div class="icon">📋</div>
        <h3>تصدير بيانات الحجوزات</h3>
        <p style="margin: 15px 0; color: #7f8c8d;">تصدير قائمة الحجوزات بصيغة CSV</p>
        <a href="?page=export&export=bookings" class="btn btn-primary">
            📥 تصدير الحجوزات
        </a>
    </div>
</div>

<div class="table-container" style="margin-top: 30px;">
    <h2 style="margin-bottom: 20px; color: #2c3e50;">معلومات التصدير</h2>
    <div style="line-height: 2;">
        <p>📌 <strong>صيغة الملف:</strong> CSV (Comma Separated Values)</p>
        <p>📌 <strong>الترميز:</strong> UTF-8 مع BOM لدعم اللغة العربية</p>
        <p>📌 <strong>البرامج المدعومة:</strong> Microsoft Excel, Google Sheets, LibreOffice Calc</p>
        <p>📌 <strong>محتوى التصدير:</strong> جميع البيانات المتوفرة في النظام</p>
        <p>📌 <strong>اسم الملف:</strong> يحتوي على نوع البيانات والتاريخ</p>
    </div>
</div>

<div class="table-container" style="margin-top: 30px;">
    <h2 style="margin-bottom: 20px; color: #2c3e50;">إرشادات الاستخدام</h2>
    <ol style="line-height: 2; padding-right: 30px;">
        <li>انقر على زر التصدير المناسب أعلاه</li>
        <li>سيتم تنزيل الملف تلقائياً على جهازك</li>
        <li>افتح الملف باستخدام Excel أو أي برنامج جداول بيانات</li>
        <li>يمكنك تحرير البيانات أو طباعتها أو مشاركتها</li>
        <li>احتفظ بنسخة احتياطية من بياناتك بانتظام</li>
    </ol>
</div>